/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.events;

import com.cisco.pt.UUID;
import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.ipc.events.IPCEventRegistry;
import com.cisco.pt.ipc.events.LogicalWorkspaceEvent;
import com.cisco.pt.ipc.events.LogicalWorkspaceEventListener;
import com.cisco.pt.ipc.ui.LogicalWorkspace;
import com.cisco.pt.ptmp.PacketTracerSession;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogicalWorkspaceEventRegistry
extends IPCEventRegistry {
    protected Set<LogicalWorkspaceEventListener> globalListeners = new HashSet<LogicalWorkspaceEventListener>();
    protected Map<String, Set<LogicalWorkspaceEventListener>> specificObjectListeners = new HashMap<String, Set<LogicalWorkspaceEventListener>>();
    private static Log logger = LogFactory.getLog(LogicalWorkspaceEventRegistry.class);

    public LogicalWorkspaceEventRegistry(PacketTracerSession session) {
        super(session);
    }

    @Override
    public String getClassName() {
        return "LogicalWorkspace";
    }

    @Override
    public void processEvent(IPCEventLTV event) throws Exception {
        String eventName = event.getEventName();
        LogicalWorkspaceEvent evt = null;
        if (eventName.equalsIgnoreCase("deviceAdded")) {
            evt = new LogicalWorkspaceEvent.DeviceAdded(event);
        } else if (eventName.equalsIgnoreCase("deviceRemoved")) {
            evt = new LogicalWorkspaceEvent.DeviceRemoved(event);
        } else if (eventName.equalsIgnoreCase("remoteNetworkAdded")) {
            evt = new LogicalWorkspaceEvent.RemoteNetworkAdded(event);
        } else if (eventName.equalsIgnoreCase("remoteNetworkRemoved")) {
            evt = new LogicalWorkspaceEvent.RemoteNetworkRemoved(event);
        } else if (eventName.equalsIgnoreCase("linkCreated")) {
            evt = new LogicalWorkspaceEvent.LinkCreated(event);
        } else if (eventName.equalsIgnoreCase("linkDeleted")) {
            evt = new LogicalWorkspaceEvent.LinkDeleted(event);
        } else {
            logger.info((Object)("Unrecognized eventName for " + this.getClassName() + ": " + eventName));
            return;
        }
        for (LogicalWorkspaceEventListener listener : this.globalListeners) {
            listener.handleEvent(evt);
        }
        Set<LogicalWorkspaceEventListener> specificListeners = this.specificObjectListeners.get(evt.objectUUID.toString());
        if (specificListeners != null) {
            for (LogicalWorkspaceEventListener listener : specificListeners) {
                listener.handleEvent(evt);
            }
        }
    }

    public void addListenerFiltered(LogicalWorkspaceEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (events == null) {
                this.register("deviceAdded");
                this.register("deviceRemoved");
                this.register("remoteNetworkAdded");
                this.register("remoteNetworkRemoved");
                this.register("linkCreated");
                this.register("linkDeleted");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(events.get(i));
                }
            }
        }
        this.globalListeners.add(listener);
    }

    public void addSpecificListenerFiltered(LogicalWorkspaceEventListener listener, LogicalWorkspace objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<LogicalWorkspaceEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners == null) {
            specificListeners = new HashSet<LogicalWorkspaceEventListener>();
            this.specificObjectListeners.put(uuidString, specificListeners);
            if (events == null) {
                this.register(uuid, "deviceAdded");
                this.register(uuid, "deviceRemoved");
                this.register(uuid, "remoteNetworkAdded");
                this.register(uuid, "remoteNetworkRemoved");
                this.register(uuid, "linkCreated");
                this.register(uuid, "linkDeleted");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(uuid, events.get(i));
                }
            }
        }
        specificListeners.add(listener);
    }

    public void removeListenerFiltered(LogicalWorkspaceEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() != 0) {
            if (events == null) {
                this.deregister("deviceAdded");
                this.deregister("deviceRemoved");
                this.deregister("remoteNetworkAdded");
                this.deregister("remoteNetworkRemoved");
                this.deregister("linkCreated");
                this.deregister("linkDeleted");
            }
            this.globalListeners.remove(listener);
        }
    }

    public void removeSpecificListenerFiltered(LogicalWorkspaceEventListener listener, LogicalWorkspace objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<LogicalWorkspaceEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners != null && !specificListeners.isEmpty()) {
            this.deregister(uuid, "deviceAdded");
            this.deregister(uuid, "deviceRemoved");
            this.deregister(uuid, "remoteNetworkAdded");
            this.deregister(uuid, "remoteNetworkRemoved");
            this.deregister(uuid, "linkCreated");
            this.deregister(uuid, "linkDeleted");
            specificListeners.remove(listener);
        }
    }

    public void addListener(LogicalWorkspaceEventListener listener) throws IOException {
        this.addListenerFiltered(listener, null);
    }

    public void addListener(LogicalWorkspaceEventListener listener, LogicalWorkspace objClass) throws IOException {
        this.addSpecificListenerFiltered(listener, objClass, null);
    }

    public void removeListener(LogicalWorkspaceEventListener listener) throws IOException {
        this.removeListenerFiltered(listener, null);
    }

    public void removeListener(LogicalWorkspaceEventListener listener, LogicalWorkspace objClass) throws IOException {
        this.removeSpecificListenerFiltered(listener, objClass, null);
    }
}

